import { World, WorldItem } from './app/worldES6.js'

var app = { };

app.load = function () {
    console.log("Hello!")

    const ROWS = 40;
    const COLS = 60;

    let myGrid = [];

    // Initialize a world grid based on ROWS and COLS above
    for (let i = 0; i < ROWS; i++) {
        
        myGrid[i] = [];
        for (let j = 0; j < COLS; j++) {

            if (i == 0 || j == 0 || i == ROWS-1 || j == COLS -1 ) {
                myGrid[i][j] = "#";
            } else {
                let next = ' ';
                let num = Math.random() * 10;
                if (num <= 2.5) {
                    next = "#";
                } else if (num <= 5) {
                    next = "p";
                } else if (num <= 7.5) {
                    next = "a";
                } else { 
                    next = " ";
                }

                myGrid[i][j] = next;

            }
        }
    }

    // Convert the above grid to a string
    let gridString = World.gridToString(myGrid);
    var world = new World(gridString);
    animateWorld(world);
}

export { app };
