
import { WorldItem } from "./world-item.js";

var worldItemFactory = {};

worldItemFactory.build = function(symbol, rowIndex, columnIndex) {

	var type;
	var targetMoveWorldItemTypes;
	
	switch (symbol) {
		
		case "#":
			type = "wall";
			break;

		case "p":
			type = "plant";
			targetMoveWorldItemTypes = ["empty"];
			break;

		case "a":
			type = "animal";
			targetMoveWorldItemTypes = ["empty", "plant"];
			break;

		case " ":
			type = "empty";
			break;
	}

	return new WorldItem(type, symbol, rowIndex, columnIndex, targetMoveWorldItemTypes);
}


export { worldItemFactory }