
import { coreMath } from "../lib/core/core-math.js";

function WorldItem(type, symbol, rowIndex, columnIndex, targetMoveWorldItemTypes) {

	this.type = type;
	this.symbol = symbol;
	this.rowIndex = rowIndex;
	this.columnIndex = columnIndex;
	this.targetMoveWorldItemTypes = targetMoveWorldItemTypes;
}

WorldItem.prototype.act = function(world) {

	var hasDied;

	switch (this.type) {
		
		case "plant":

			hasDied = this.tryToDie(world);

			if (!hasDied) {

				this.tryToReproduce(world);
			}

			break;

		case "animal":

			hasDied = this.tryToDie(world);

			if (!hasDied) {

				this.tryToReproduce(world);
				this.tryToMove(world);
			}

			break;
	}
}

WorldItem.prototype.tryToDie = function(world) {

	var hasDied = Math.random() < 10 / 100;

	if (hasDied) {

		world.remove(this);
	}

	return hasDied;
}

WorldItem.prototype.tryToReproduce = function(world) {

	var hasReproduced = Math.random() < 30 / 100;

	if (hasReproduced) {

		hasReproduced = false;

		var worldItems = world.look(this, this.targetMoveWorldItemTypes);

		if (worldItems.length > 0) {

			var randomIndex = coreMath.randomInteger(0, worldItems.length - 1);
			var targetWorldItem = worldItems[randomIndex];

			world.copy(targetWorldItem, this);
			hasReproduced = true;
		}
	}

	return hasReproduced;
}

WorldItem.prototype.tryToMove = function(world) {

	var hasMoved = Math.random() < 30 / 100;

	if (hasMoved) {

		hasMoved = false;

		var worldItems = world.look(this, this.targetMoveWorldItemTypes);

		if (worldItems.length > 0) {

			var randomIndex = coreMath.randomInteger(0, worldItems.length - 1);
			var targetWorldItem = worldItems[randomIndex];

			world.move(targetWorldItem, this);

			hasMoved = true;
		}
	}

	return hasMoved;
}


export { WorldItem }