
import { coreMath } from "../lib/core/core-math.js";

var buildWorldPlan = function(numberOfRows, numberOfColumns) {

	var worldPlan = getRowOfWalls(numberOfColumns) + "\n";

	for (var count = 0; count < numberOfRows - 2; count++) {

		worldPlan += getRow(numberOfColumns);
	}

	worldPlan += getRowOfWalls(numberOfColumns);

	return worldPlan;
}

function getRowOfWalls(numberOfColumns) {

	var row = "";

	for (var count = 0; count < numberOfColumns; count++) {

		row += "#";
	}

	return row;
}

function getRow(numberOfColumns) {

	var row = "#";

	for (var count = 0; count < numberOfColumns - 2; count++) {

		if (coreMath.randomBooleanForPercent(10)) {

			row += "#";

		} else if (coreMath.randomBooleanForPercent(5)) {

			row += "a";

		} else if (coreMath.randomBooleanForPercent(5)) {

			row += "p";

		} else {
			
			row += " ";
		}
	}

	row += "#" + "\n";

	return row;
}


export { buildWorldPlan }