import { World, WorldItemFactory, worldPlanBuilder } from './app/worldES6.js'

var app = { };

app.load = function () {
    console.log("Hello!")

    const ROWS = 40;
    const COLS = 60;
    let itemOptions = {

        wall: { symbol: "#", buildChance: 10 },
        plant: { symbol: "p", buildChance: 2, ableToMoveOn: ["empty"] },
        animal: { symbol: "a", buildChance: 2, ableToMoveOn: ["empty", "plant"] },
        carnivore: { symbol: "c", buildChance: 2, ableToMoveOn: ["empty", "animal"] },
        empty: { symbol: " ", buildChance: null }
    };
    
    
    let worldPlan = worldPlanBuilder(ROWS, COLS, itemOptions);
    let worldItemFactory = new WorldItemFactory(itemOptions);
    var world = new World(worldPlan, worldItemFactory);
    animateWorld(world);
}

export { app };
