
import { WorldItem } from "./world-items/world-item.js";
import { PlantWorldItem } from "./world-items/plant-world-item.js";
import { AnimalWorldItem } from "./world-items/animal-world-item.js";
import { CarnivoreWorldItem } from "./world-items/carnivore-world-item.js";

function WorldItemFactory(worldItemTypeSymbols) {

	this.worldItemTypeSymbols = worldItemTypeSymbols;
	this.worldItemSymbolTypes = {};

	var worldItemTypes = Object.keys(worldItemTypeSymbols);

	worldItemTypes.forEach(function(type) {

		var worldItemTypeSymbol = worldItemTypeSymbols[type];

		this.worldItemSymbolTypes[worldItemTypeSymbol.symbol] = type;

	}.bind(this));
}

WorldItemFactory.prototype.buildFromSymbol = function(symbol, rowIndex, columnIndex) {

	var type = this.worldItemSymbolTypes[symbol];

	return this.build(type, rowIndex, columnIndex);
}

WorldItemFactory.prototype.build = function(type, rowIndex, columnIndex) {

	var worldItem;
	var symbol = this.worldItemTypeSymbols[type].symbol;

	switch (type) {

		case "plant":
			worldItem = new PlantWorldItem(symbol, rowIndex, columnIndex);
			break;

		case "animal":
			worldItem = new AnimalWorldItem(symbol, rowIndex, columnIndex);
			break;

		case "carnivore":
			worldItem = new CarnivoreWorldItem(symbol, rowIndex, columnIndex);
			break;

		default:
			worldItem = new WorldItem(type, symbol, rowIndex, columnIndex);
			break;
	}

	return worldItem;
}


export { WorldItemFactory }