
import { WorldItem } from "./world-item.js";

function AnimalWorldItem(symbol, rowIndex, columnIndex) {

	WorldItem.call(this, "animal", symbol, rowIndex, columnIndex, ["empty", "plant"]);

	this.chanceToDie = 10;
	this.chanceToReproduce = 5;
	this.chanceToMove = 5;
}

AnimalWorldItem.prototype = Object.create(WorldItem.prototype);

AnimalWorldItem.prototype.act = function(world) {

	var hasDied = this.tryToDie(world, this.chanceToDie);

	if (!hasDied) {

		this.tryToReproduce(world, this.chanceToReproduce);
		this.tryToMove(world, this.chanceToMove);
	}
}


export { AnimalWorldItem }