
import { WorldItem } from "./world-item.js";

function CarnivoreWorldItem(symbol, rowIndex, columnIndex) {

	WorldItem.call(this, "carnivore", symbol, rowIndex, columnIndex, ["empty", "animal"]);

	this.chanceToDie = 10;
	this.chanceToReproduce = 5;
	this.chanceToMove = 15;
}

CarnivoreWorldItem.prototype = Object.create(WorldItem.prototype);

CarnivoreWorldItem.prototype.act = function(world) {

	var hasDied = this.tryToDie(world, this.chanceToDie);

	if (!hasDied) {

		this.tryToReproduce(world, this.chanceToReproduce);
		var hasMoved = this.tryToMove(world, this.chanceToMove);

		if (hasMoved) {

			this.tryToReproduce(world, this.chanceToReproduce / 2);
			var hasMoved = this.tryToMove(world, this.chanceToMove / 2);
		}
	}
}


export { CarnivoreWorldItem }