/* Norton's spin on the Virtual World project #7 (May 2019)

Contains its own animator and view layer now, the latter
based on the DOM and CSS style for elements.

Now compliant with ES6 strictness and import/export.
Follows the factory pattern; assumes an options object is 
passed in from the client to the worldPlanBuilder and 
WorldItemFactory object.

Refer to the index.html to see how the app.js is used as an ES6 module.
*/

function worldPlanBuilder(ROWS, COLS, itemOptions) {

    let myGrid = [];

    // Initialize a world grid based on ROWS and COLS above
    for (let i = 0; i < ROWS; i++) {
        
        myGrid[i] = [];
        for (let j = 0; j < COLS; j++) {

            // if (i == 0 || j == 0 || i == ROWS - 1 || j == COLS - 1 ) {

            //     myGrid[i][j] = itemOptions.wall.symbol;
            
            // } else {

                let next = itemOptions.empty.symbol;
                let num = Math.random();
                let refNum = 0;

                for (let i in itemOptions) {

                    refNum += itemOptions[i].buildChance;
                    if (num <= refNum) {
                        next = itemOptions[i].symbol;
                        break;
                    }

                }

                myGrid[i][j] = next;

            // }
        }
    }

    // Convert the above grid to a string (worldPlan)
    let worldPlan = World.gridToString(myGrid);
    return worldPlan;
}

class World {

    constructor(worldPlan, worldItemFactory) {

        this.worldItemFactory = worldItemFactory;
        this.grid = this.stringToGrid(worldPlan);
        this.rows = this.grid.length;
        this.cols = this.grid[0].length;
    }

}

World.prototype.stringToGrid = function(string) {

    let grid = [];
    let rowNum = 0;
    let colNum = 0;

    grid.push([]);

    for (let c of string) {
        if (c == '\n') {
            rowNum++;
            colNum = 0;
            grid.push([]);
            continue;
        }
        grid[rowNum].push(this.worldItemFactory.buildFromSymbol(c, rowNum, colNum));
        colNum++;
    }

    return grid;

}

World.gridToString = function(grid) {

    let responseString = "";

    for (let i = 0; i < grid.length; i++) {
        for (let j = 0; j < grid[0].length; j++) {
            responseString += grid[i][j];
        }
        
        responseString += '\n';
    }
    return responseString.slice(0,responseString.length - 1);
    
}


World.prototype.toString = function() {

    let responseString = "";

    for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.cols; j++) {
            responseString += this.grid[i][j].symbol;
        }
        responseString += '\n';
    }

    return responseString.slice(0,responseString.length - 1);

}

World.prototype.move = function(targetWorldItem, sourceWorldItem) {

    this.copy(targetWorldItem, sourceWorldItem);
    this.remove(sourceWorldItem);
}

World.prototype.remove = function(worldItem) {
    // console.log(`Death: ${worldItem.type} @ ${worldItem.latitude},${worldItem.longitude}`);
    this.grid[worldItem.latitude][worldItem.longitude] = this.worldItemFactory.buildFromSymbol(" ", worldItem.latitude, worldItem.longitude);
}

World.prototype.copy = function(targetWorldItem, sourceWorldItem) {
    this.grid[targetWorldItem.latitude][targetWorldItem.longitude] = this.worldItemFactory.buildFromSymbol(sourceWorldItem.symbol, targetWorldItem.latitude, targetWorldItem.longitude);
}

World.prototype.getObjectAt = function(latitude, longitude) {
    return this.grid[latitude][longitude];
}

World.prototype.getHeight = function() {
    return this.grid.length;
}

World.prototype.getWidth = function() {
    return this.grid[0].length;
}

World.prototype.turn = function() {

    for (let i = 0; i < this.rows; i++) {
        for (let j = 0; j < this.cols; j++) {

            let current = this.getObjectAt(i,j);
            
            if (current.type != "wall" && current.type != "empty") {
                current.act(this);
            }

        }
    }
}

export { World, worldPlanBuilder };