function WorldItem(latitude,longitude,typeOptions) { 
     
    this.latitude = latitude;
	this.longitude = longitude;
    this.type = typeOptions.type;
    this.symbol = typeOptions.symbol;
    this.chanceToMove = typeOptions.chanceToMove;
    this.ableToMoveOn = typeOptions.ableToMoveOn;  
    this.chanceToSurvive = typeOptions.chanceToSurvive;
    this.chanceToReproduce = typeOptions.chanceToReproduce;

}

WorldItem.prototype.act = function(world) {

}


WorldItem.prototype.notSelf = function(row,col) {
    return (!(row == this.latitude && col == this.longitude));
}


WorldItem.prototype.doIfInBoundsAndNotSelf = function(world, callback) {
    
    let y = this.latitude;
    let x = this.longitude;
    let radius = 1;

    let possibleMoves = [];

    // Create an array of possible moves:
    for (let r = y - radius; r <= y + radius; r++) {
        
        for (let c = x + radius; c >= x - radius; c--) {
            
            if (this.notSelf(r,c)) {

                let targetRow = r;
                let targetCol = c;

                // Simulate a globe....
                if (targetRow < 0) { 
                    targetRow = world.getHeight() - 1;
                } else if (targetRow >= world.getHeight()) {
                    targetRow = 0;
                }

                if (targetCol < 0) { 
                    targetCol = world.getWidth() - 1;
                } else if (targetCol >= world.getWidth()) {
                    targetCol = 0;
                }

                possibleMoves.push({r: targetRow, c: targetCol});
            }
        }
    }

    // Shuffle:
    possibleMoves = shuffle(possibleMoves);

    // Attempt the callback for each in turn; break if successful:
    for (let possibleMove of possibleMoves) {
        let target = world.getObjectAt(possibleMove.r,possibleMove.c);
        if (callback(target, this)) break;
    }
}

WorldItem.prototype.reproduce = function(world) {

    this.doIfInBoundsAndNotSelf(world, function(target, source) {
        
        if (target.type == "empty") {
            // console.log(`Copying ${source.type} from ${source.latitude},${source.longitude} to ${target.latitude},${target.longitude}`);
            world.copy(target, source);
            return true;
        }

        return false;
    });
}

WorldItem.prototype.move = function(world) {
   
    this.doIfInBoundsAndNotSelf(world, function(target, source) {
        
        if (source.ableToMoveOn && source.ableToMoveOn.some(e => e == target.type)) {
            
            // if (target.type == 'plant') {
            //     console.log(`Squashing plant: ${source.type} from ${source.latitude},${source.longitude} to ${target.latitude},${target.longitude}`);
            // }   
            world.move(target, source);
            return true;
        }

        return false;
    });
}

function LivingWorldItem(...args) {
    WorldItem.call(this, ...args);
}

LivingWorldItem.prototype = Object.create(WorldItem.prototype);

function PlantWorldItem(...args) {
    LivingWorldItem.call(this, ...args);
}

LivingWorldItem.prototype.act = function(world) {

    let alive = true;
    alive = Math.random() < this.chanceToSurvive ? true : false;
 
    if (alive) {

        let shouldReproduce = Math.random() < this.chanceToReproduce ? true : false;
        if (shouldReproduce) {
            this.reproduce(world);
        }

        let shouldMove = Math.random() < this.chanceToMove ? true : false;
            if (shouldMove) {
                this.move(world);
            }

    } else {

        world.remove(this);

    }
}


PlantWorldItem.prototype = Object.create(LivingWorldItem.prototype);

function AnimalWorldItem(...args) {
    LivingWorldItem.call(this, ...args);
}

AnimalWorldItem.prototype = Object.create(LivingWorldItem.prototype);

function CarnivoreWorldItem(...args) {
    AnimalWorldItem.call(this, ...args);
}

CarnivoreWorldItem.prototype = Object.create(AnimalWorldItem.prototype);


// Borrowed from D3 code :-)
let shuffle = function(array, i0, i1) {
    if ((m = arguments.length) < 3) {
      i1 = array.length;
      if (m < 2) i0 = 0;
    }
    var m = i1 - i0, t, i;
    while (m) {
      i = Math.random() * m-- | 0;
      t = array[m + i0], array[m + i0] = array[i + i0], array[i + i0] = t;
    }
    return array;
};



export { WorldItem, CarnivoreWorldItem, AnimalWorldItem, PlantWorldItem };