/* Norton's VirtualLife rendition (2019) */
const scale = 10;

function WorldView(worldString, parent) {
  this.worldGrid = stringToGrid(worldString);
  this.dom = elt("div", { class: "life" }, drawLifeGrid(this.worldGrid));
  this.initialized = false;
  this.parent = parent;
}

WorldView.prototype.clear = function() {
  this.dom.remove();
};

WorldView.prototype.initialize = function() {
  this.clear();
  this.dom.className = `${status}`;
  this.parent.appendChild(this.dom);
  this.initialized = true;

  this.parent.appendChild(this.dom);
};

WorldView.prototype.render = function(worldString) {
  // // Create and append DOM objects to the body
  // var gridElement = document.createElement("div");
  // gridElement.innerHTML = "Hello";
  // document.body.appendChild(gridElement);

  let newWorldGrid = stringToGrid(worldString);

  for (let y = 0; y < newWorldGrid.length; y++) {
    for (let x = 0; x < newWorldGrid[0].length; x++) {
      if (newWorldGrid[y][x] != this.worldGrid[y][x]) {
        this.updateGrid(y, x, newWorldGrid[y][x]);
        this.worldGrid[y][x] = newWorldGrid[y][x];
      }
    }
  }
};

WorldView.prototype.updateGrid = function(y, x, newValue) {
  let thisElement = document.getElementById(
    `${zeroPad(y, 3)}y${zeroPad(x, 3)}x`
  );
  thisElement.className = newValue;
};

function zeroPad(number, width) {
  let string = String(number);
  while (string.length < width) {
    string = "0" + string;
  }
  return string;
}

// Haverbeke's elt function
function elt(name, attrs, ...children) {
  let dom = document.createElement(name);

  for (let attr of Object.keys(attrs)) {
    dom.setAttribute(attr, attrs[attr]);
  }

  for (let child of children) {
    dom.appendChild(child);
  }

  return dom;
}

function drawLifeGrid(worldGrid) {
  return elt(
    "table",
    {
      class: "background",
      style: `width: ${worldGrid[0].length * scale}px`
    },
    ...worldGrid.map((row, y) =>
      elt(
        "tr",
        {
          style: `height: ${scale}px`
        },
        ...row.map((type, x) =>
          elt("td", {
            class: `${type}`,
            id: `${zeroPad(y, 3)}y${zeroPad(x, 3)}x`
          })
        )
      )
    )
  );
}

function stringToGrid(string) {
  let grid = [];
  let rowNum = 0;

  grid.push([]);

  for (let c of string) {
    if (c == "\n") {
      rowNum++;
      grid.push([]);
      continue;
    }
    grid[rowNum].push(c);
  }

  return grid;
}

export { WorldView };
