
import { buildWorldPlan } from "./app/world-plan-builder.js"
import { WorldItemFactory } from "./app/world-items/world-item-factory.js";
import { World } from "./app/world.js";
import { WorldAnimator } from './app/world-animator.js';

var app = {};

app.load = function() {

	var worldItemTypeSymbolsBuildChances = {
		wall: { symbol: "#", buildChance: 10 },
		plant: { symbol: "p", buildChance: 2 },
		animal: { symbol: "a", buildChance: 2 },
		carnivore: { symbol: "c", buildChance: 2 },
		empty: { symbol: " ", buildChance: null }
	};

	var worldPlan = buildWorldPlan(20, 60, worldItemTypeSymbolsBuildChances);
	var worldItemFactory = new WorldItemFactory(worldItemTypeSymbolsBuildChances);
	var world = new World(worldPlan, worldItemFactory);
	var worldAnimator = new WorldAnimator(world);

	worldAnimator.start();
}


export { app }