
import { WorldView } from "./world-view.js";

function WorldAnimator(world) {

	this.world = world;
	this.worldView = new WorldView();
	this.animationIntervalId;
	this.animateWorldInterval = 333;
}

WorldAnimator.prototype.start = function() {

	var worldString = this.world.toString();

	this.worldView.initialize(worldString);

	this.animationIntervalId = setInterval(this.onAnimateWorld.bind(this), this.animateWorldInterval);
}

WorldAnimator.prototype.onAnimateWorld = function() {

	this.world.turn();

	var worldString = this.world.toString();

	this.worldView.render(worldString);
}


export { WorldAnimator };