
import { coreMath } from "../lib/core/core-math.js";

var buildWorldPlan = function(numberOfRows, numberOfColumns, worldItemTypeSymbolsBuildChances) {

	var wallSymbolAndBuildChance = worldItemTypeSymbolsBuildChances["wall"];

	var worldPlan = getRowOfWalls(numberOfColumns, wallSymbolAndBuildChance.symbol) + "\n";

	for (var count = 0; count < numberOfRows - 2; count++) {

		worldPlan += getRow(numberOfColumns, wallSymbolAndBuildChance, worldItemTypeSymbolsBuildChances);
	}

	worldPlan += getRowOfWalls(numberOfColumns, wallSymbolAndBuildChance.symbol);

	return worldPlan;
}

function getRowOfWalls(numberOfColumns, wallSymbol) {

	var row = "";

	for (var count = 0; count < numberOfColumns; count++) {

		row += wallSymbol;
	}

	return row;
}

function getRow(numberOfColumns, wallSymbolAndBuildChance, worldItemTypeSymbolsBuildChances) {

	var worldItemTypes = Object.keys(worldItemTypeSymbolsBuildChances);
	var filteredWorldItemTypes = worldItemTypes.filter(function(type) {

		return (type != "wall" && type != "empty");
	});

	var row = wallSymbolAndBuildChance.symbol;

	for (var count = 0; count < numberOfColumns - 2; count++) {

		var hasSymbol = false;

		for (var index = 0; index < filteredWorldItemTypes.length; index++) {

			var type = filteredWorldItemTypes[index];
			var symbolAndChance = worldItemTypeSymbolsBuildChances[type];
			hasSymbol = coreMath.randomBooleanForPercent(symbolAndChance.buildChance);

			if (hasSymbol) {

				row += symbolAndChance.symbol;
				break;
			}
		}

		if (!hasSymbol) {

			hasSymbol = coreMath.randomBooleanForPercent(wallSymbolAndBuildChance.buildChance);

			if (hasSymbol) {

				row += wallSymbolAndBuildChance.symbol;

			} else {

				row += worldItemTypeSymbolsBuildChances["empty"].symbol;
			}
		}
	}

	row += wallSymbolAndBuildChance.symbol + "\n";

	return row;
}


export { buildWorldPlan }