
function WorldView() {

	this.tableElement;
	this.tableCellElements = [];
	this.tableCellSize = 20;
}

WorldView.prototype.initialize = function(worldString) {

	this.createTable(worldString);
}

WorldView.prototype.render = function(worldString) {

	this.updateTableCellElements(worldString);
}

WorldView.prototype.createTable = function(worldString) {

	this.tableElement = document.createElement("table");
	var rowElement = document.createElement("tr");
	var tableCellCount = 0;

	this.forEachWorldItemSymbol(worldString, function(symbol) {

		if (symbol !== null) {

			var cellElement = document.createElement("td");
			cellElement.style.height = this.tableCellSize + "px";
			cellElement.style.lineHeight = this.tableCellSize + "px";
			cellElement.style.width = this.tableCellSize + "px";

			cellElement.innerHTML = symbol

			rowElement.appendChild(cellElement);
			this.tableCellElements.push(cellElement);

		} else {

			this.tableElement.appendChild(rowElement);
			tableCellCount++;

			rowElement = document.createElement("tr");
		}
	}.bind(this));

	this.tableElement.appendChild(rowElement);
	tableCellCount++;

	document.body.appendChild(this.tableElement);

	this.tableElement.style.height = (tableCellCount * this.tableCellSize) + "px";
	this.tableElement.style.width = (tableCellCount * this.tableCellSize) + "px";
}

WorldView.prototype.updateTableCellElements = function(worldString) {

	document.body.style.setProperty("display", "none");

	var index = 0;

	this.forEachWorldItemSymbol(worldString, function(symbol) {

		if (symbol != null) {

			this.tableCellElements[index].innerHTML = symbol;

			index++;
		}

	}.bind(this));

	document.body.style.setProperty("display", "block");
}

WorldView.prototype.forEachWorldItemSymbol = function(worldString, callback) {

	worldString = worldString.trim();

	for (var index = 0; index < worldString.length; index++) {

		var symbol = worldString[index];

		if (symbol === "\n") {

			callback(null);

		} else {

			callback(symbol);
		}
	}
}


export { WorldView };