
var lookDirectionDifferentials = [
	{ rowIndex: -1, columnIndex: -1 },
	{ rowIndex: -1, columnIndex: 0 },
	{ rowIndex: -1, columnIndex: 1 },
	{ rowIndex: 0, columnIndex: -1 },
	{ rowIndex: 0, columnIndex: 1 },
	{ rowIndex: 1, columnIndex: -1 },
	{ rowIndex: 1, columnIndex: 0 },
	{ rowIndex: 1, columnIndex: 1 },
];

function World(worldPlan, worldItemFactory) {

	this.grid = parseWorldPlan(worldPlan, worldItemFactory);
	this.worldItemFactory = worldItemFactory;
};

World.prototype.turn = function() {

	var currentWorldItem;

	for (var rowIndex = 0; rowIndex < this.grid.length; rowIndex++) {

		for (var columnIndex = 0; columnIndex < this.grid[rowIndex].length; columnIndex++) {

			currentWorldItem = this.grid[rowIndex][columnIndex];

			currentWorldItem.act(this);
		}
	}
};

World.prototype.toString = function() {

	var result = "";
	var worldItem;

	for (var rowIndex = 0; rowIndex < this.grid.length; rowIndex++) {

		for (var columnIndex = 0; columnIndex < this.grid[rowIndex].length; columnIndex++) {

			worldItem = this.grid[rowIndex][columnIndex];

			result += worldItem.symbol;
		}

		result += "\n";
	}

	return result;
};

World.prototype.look = function(worldItem, targetWorldItemTypes) {

	var foundWorldItems = [];

	for (var index = 0; index < lookDirectionDifferentials.length; index++) {

		var lookDirectionDifferential = lookDirectionDifferentials[index];
		var targetRowIndex = worldItem.rowIndex + lookDirectionDifferential.rowIndex;
		var targetColumnIndex = worldItem.columnIndex + lookDirectionDifferential.columnIndex;
		var targetWorldItem = this.grid[targetRowIndex][targetColumnIndex];

		for (var indexTargetWorldItemTypes = 0; indexTargetWorldItemTypes < targetWorldItemTypes.length; indexTargetWorldItemTypes++) {

			var targetWorldItemType = targetWorldItemTypes[indexTargetWorldItemTypes];

			if (targetWorldItem.type === targetWorldItemType) {

				foundWorldItems.push(targetWorldItem);
				break;
			}
		}
	}

	return foundWorldItems;
}

World.prototype.copy = function(targetWorldItem, sourceWorldItem) {

	var newWorldItem = this.worldItemFactory.build(sourceWorldItem.type, targetWorldItem.rowIndex, targetWorldItem.columnIndex);

	this.grid[targetWorldItem.rowIndex][targetWorldItem.columnIndex] = newWorldItem;
}

World.prototype.move = function(targetWorldItem, sourceWorldItem) {

	var emptyWorldItem = this.worldItemFactory.build("empty", sourceWorldItem.rowIndex, sourceWorldItem.columnIndex);

	this.grid[sourceWorldItem.rowIndex][sourceWorldItem.columnIndex] = emptyWorldItem;

	sourceWorldItem.rowIndex = targetWorldItem.rowIndex;
	sourceWorldItem.columnIndex = targetWorldItem.columnIndex;

	this.grid[targetWorldItem.rowIndex][targetWorldItem.columnIndex] = sourceWorldItem;
}

World.prototype.remove = function(worldItem) {

	var emptyWorldItem = this.worldItemFactory.build("empty", worldItem.rowIndex, worldItem.columnIndex);

	this.grid[worldItem.rowIndex][worldItem.columnIndex] = emptyWorldItem;
}

function parseWorldPlan(worldPlan, worldItemFactory) {

	var grid = [];

	grid.push([]);

	var rowIndex = 0;
	var columnIndex = 0;

	for (var index = 0; index < worldPlan.length; index++) {

		var symbol = worldPlan[index];

		if (symbol === "\n") {

			grid.push([]);

			columnIndex = 0;
			rowIndex++;

		} else {

			var worldItem = worldItemFactory.buildFromSymbol(symbol, rowIndex, columnIndex);

			grid[rowIndex].push(worldItem);

			columnIndex++;
		}
	}

	return grid;
}


export { World }