/* Norton's VirtualLife rendition (2019) */
 
import { World, worldPlanBuilder } from './app/worldES6.js'
import { WorldItemFactory } from './app/worldItemFactory.js'
import { WorldAnimator } from './app/worldAnimator.js'

var app = { };

app.load = function () {

    const ROWS = 40;
    const COLS = 100;
    let itemOptions = {

        wall: { type: "wall", symbol: "w", buildChance: .1 },

        plant: { type: "plant", symbol: "p", buildChance: 0.02, ableToMoveOn: [ "empty" ], 
                    chanceToSurvive: 0.64, chanceToReproduce: 0.6, chanceToMove: 0.1 },

        animal: { type: "animal", symbol: "a", buildChance: 0.02, ableToMoveOn: [ "empty", "plant" ], 
                    chanceToSurvive: 0.625, chanceToReproduce: 0.622, chanceToMove: 0.49 },

        carnivore: { type: "carnivore", symbol: "c", buildChance: 0.02, ableToMoveOn: [ "empty", "animal" ], 
                    chanceToSurvive: 0.62, chanceToReproduce: 0.622, chanceToMove: 0.75 },

        empty: { type: "empty", symbol: "z", buildChance: null }
    };
    
    
    let worldPlan = worldPlanBuilder(ROWS, COLS, itemOptions);
    let worldItemFactory = new WorldItemFactory(itemOptions);
    var world = new World(worldPlan, worldItemFactory);
    // animateWorld(world);

    var worldAnimator = new WorldAnimator(world);
    worldAnimator.start();

}

export { app };
