
import { buildWorldPlan } from "./app/world-plan-builder.js"
import { WorldItemFactory } from "./app/world-items/world-item-factory.js";
import { World } from "./app/world.js";
import { WorldAnimator } from './app/world-animator.js';

var app = {};

app.load = function() {

	var worldItemTypeOptions = {
		wall: { symbol: "#", buildChance: 5, color: "#deb887", icon: "" },
		plant: { symbol: "p", buildChance: 20, color: "#006400", icon: "tree" },
		animal: { symbol: "a", buildChance: 10, color: "#a52a2a", icon: "horse" },
		carnivore: { symbol: "c", buildChance: 2, color: "#808080", icon: "hippo" },
		empty: { symbol: " ",  buildChance: null, color: "#ffffff", icon: "" }
	};

	var worldPlan = buildWorldPlan(30, 50, worldItemTypeOptions);
	var worldItemFactory = new WorldItemFactory(worldItemTypeOptions);
	var world = new World(worldPlan, worldItemFactory);
	var worldAnimator = new WorldAnimator(world, worldItemTypeOptions);

	worldAnimator.start();
}


export { app }