
import { WorldItem } from "./world-item.js";

function PlantWorldItem(symbol, rowIndex, columnIndex) {

	WorldItem.call(this, "plant", symbol, rowIndex, columnIndex, ["empty"]);

	this.chanceToDie = 10;
	this.chanceToReproduce = 5;
}

PlantWorldItem.prototype = Object.create(WorldItem.prototype);

PlantWorldItem.prototype.act = function(world) {

	var hasDied = this.tryToDie(world, this.chanceToDie);

	if (!hasDied) {

		this.tryToReproduce(world, this.chanceToReproduce);
	}
}


export { PlantWorldItem }