
import { coreMath } from "../../lib/core/core-math.js";

function WorldItem(type, symbol, rowIndex, columnIndex, targetMoveWorldItemTypes) {

	this.type = type;
	this.symbol = symbol;
	this.rowIndex = rowIndex;
	this.columnIndex = columnIndex;
	this.targetMoveWorldItemTypes = targetMoveWorldItemTypes;
}

WorldItem.prototype.act = function() {
}

WorldItem.prototype.tryToDie = function(world, chanceToDie) {

	var hasDied = coreMath.randomBooleanForPercent(chanceToDie);

	if (hasDied) {

		world.remove(this);
	}

	return hasDied;
}

WorldItem.prototype.tryToReproduce = function(world, chanceToReproduce) {

	var hasReproduced = coreMath.randomBooleanForPercent(chanceToReproduce);

	if (hasReproduced) {

		hasReproduced = false;

		var worldItems = world.look(this, this.targetMoveWorldItemTypes);

		if (worldItems.length > 0) {

			var randomIndex = coreMath.randomInteger(0, worldItems.length - 1);
			var targetWorldItem = worldItems[randomIndex];

			world.copy(targetWorldItem, this);
			hasReproduced = true;
		}
	}

	return hasReproduced;
}

WorldItem.prototype.tryToMove = function(world, chanceToMove) {

	var hasMoved = coreMath.randomBooleanForPercent(chanceToMove);

	if (hasMoved) {

		hasMoved = false;

		var worldItems = world.look(this, this.targetMoveWorldItemTypes);

		if (worldItems.length > 0) {

			var randomIndex = coreMath.randomInteger(0, worldItems.length - 1);
			var targetWorldItem = worldItems[randomIndex];

			world.move(targetWorldItem, this);

			hasMoved = true;
		}
	}

	return hasMoved;
}


export { WorldItem }