import { WorldView } from './worldView.js'

function WorldAnimator(world) {

    this.world = world;
    this.worldView = new WorldView(this.world.viewGrid(), document.body);
    this.worldView.initialize();

}

WorldAnimator.prototype.start = function() {

    window.setInterval(() => {

        // Turn the world
        this.world.turn();

        // Render the world
        this.worldView.render(this.world.viewGrid());

    }, 20 );

}


export { WorldAnimator }
