function WorldItem(latitude,longitude,typeOptions) { 
     
    this.latitude = latitude;
	this.longitude = longitude;
    this.type = typeOptions.type;
    this.symbol = typeOptions.symbol;
    this.ableToEat = typeOptions.ableToEat;  
    this.ableToMoveOn = typeOptions.ableToMoveOn;  
    this.healthToMove = typeOptions.healthToMove;
    this.healthToReproduce = typeOptions.healthToReproduce;

}

WorldItem.prototype.act = function(world) {

}


WorldItem.prototype.notSelf = function(row,col) {
    return (!(row == this.latitude && col == this.longitude));
}


WorldItem.prototype.doIfInBoundsAndNotSelf = function(world, callback) {
    
    let y = this.latitude;
    let x = this.longitude;
    let radius = 1;

    let possibleMoves = [];

    // Create an array of possible moves:
    for (let r = y - radius; r <= y + radius; r++) {
        
        for (let c = x + radius; c >= x - radius; c--) {
            
            if (this.notSelf(r,c)) {

                let targetRow = r;
                let targetCol = c;

                // Simulate a globe....
                if (targetRow < 0) { 
                    targetRow = world.getHeight() - 1;
                } else if (targetRow >= world.getHeight()) {
                    targetRow = 0;
                }

                if (targetCol < 0) { 
                    targetCol = world.getWidth() - 1;
                } else if (targetCol >= world.getWidth()) {
                    targetCol = 0;
                }

                possibleMoves.push({r: targetRow, c: targetCol});
            }
        }
    }

    // Shuffle:
    possibleMoves = shuffle(possibleMoves);

    // Attempt the callback for each in turn; break if successful:
    for (let possibleMove of possibleMoves) {
        let target = world.getObjectAt(possibleMove.r,possibleMove.c);
        if (callback(target, this)) break;
    }
}

WorldItem.prototype.reproduce = function(world) {

    this.doIfInBoundsAndNotSelf(world, function(target, source) {
        
        if (target.type == "empty") {
            // console.log(`Copying ${source.type} from ${source.latitude},${source.longitude} to ${target.latitude},${target.longitude}`);
            world.copy(target, source);
            return true;
        }

        return false;
    });
}

WorldItem.prototype.move = function(world) {
   
    this.doIfInBoundsAndNotSelf(world, function(target, source) {
        
        if (source.ableToMoveOn && source.ableToMoveOn.some(e => e == target.type)) {
            
            // if (target.type == 'plant') {
            //     console.log(`Squashing plant: ${source.type} from ${source.latitude},${source.longitude} to ${target.latitude},${target.longitude}`);
            // }   
            world.move(target, source);
            return true;
        }

        return false; 
    });
}


class LivingWorldItem extends WorldItem {

    constructor(...args) {
        super(...args);
        this.health = Math.random() * 100;
    }
}

LivingWorldItem.prototype.survive = function(world) {

    let alive = true;

    this.health --;
    alive = this.health > 0;
 
    if (alive) {

        let shouldReproduce = this.health > this.healthToReproduce;
        if (shouldReproduce) {
            this.health--;
            this.reproduce(world);
        }

        let shouldMove = this.health > this.healthToMove;
            if (shouldMove) {
                this.health--;
                this.move(world);
        }
        return true;

    } else {

        world.remove(this);
        return false;
    }
}


class PlantWorldItem extends LivingWorldItem {

    constructor(...args) {
        super(...args);
    }
}

PlantWorldItem.prototype.act = function(world) {

    if (this.survive(world)) {
        this.health = Math.random() > 0.2 ? ++this.health : --this.health;
    }
}


// function AnimalWorldItem(...args) {
//     LivingWorldItem.call(this, ...args);
// }

// AnimalWorldItem.prototype = Object.create(LivingWorldItem.prototype);
class AnimalWorldItem extends LivingWorldItem {

    constructor(...args) {
        super(...args);
        this.plantChance = args[2].plantChance;
    }
}

AnimalWorldItem.prototype.eat = function(world) {
   
    this.doIfInBoundsAndNotSelf(world, function(target, source) {
        
        if (source.ableToEat && source.ableToEat.some(e => e == target.type)) {
            
            world.eat(target, source);
            return true;
        }

        return false; 
    });

}

AnimalWorldItem.prototype.plant = function(world) {
   
    this.doIfInBoundsAndNotSelf(world, function(target, source) {
        
        if (source.ableToMoveOn && source.ableToMoveOn.some(e => e == target.type)) {
            if (Math.random() < source.plantChance) world.plant(target);
        }
    });

}

AnimalWorldItem.prototype.act = function(world) {

    if (this.survive(world)) {
        this.eat(world);
        this.plant(world);
    }
}


class CarnivoreWorldItem extends AnimalWorldItem {

    constructor(...args) {
        super(...args);
        this.vegetarianChance = args[2].vegetarianChance;
    }
}



// Borrowed from D3 code :-)
let shuffle = function(array, i0, i1) {
    if ((m = arguments.length) < 3) {
      i1 = array.length;
      if (m < 2) i0 = 0;
    }
    var m = i1 - i0, t, i;
    while (m) {
      i = Math.random() * m-- | 0;
      t = array[m + i0], array[m + i0] = array[i + i0], array[i + i0] = t;
    }
    return array;
};



export { WorldItem, CarnivoreWorldItem, AnimalWorldItem, PlantWorldItem };