/* Norton's VirtualLife rendition (2019) */
const scale = 20;

function zeroPad(number, width) {
  let string = String(number);
  while (string.length < width) {
    string = "0" + string;
  }
  return string;
}

// Haverbeke's elt function
function elt(name, attrs, ...children) {
  let dom = document.createElement(name);

  for (let attr of Object.keys(attrs)) {
    dom.setAttribute(attr, attrs[attr]);
  }

  for (let child of children) {
    dom.appendChild(child);
  }

  return dom;
}

function drawLifeGrid(worldGrid) {
  return elt(
    "table",
    {
      id: "virtualWorld",
      class: "background",
      style: `width: ${worldGrid[0].length * scale}px`
    },
    ...worldGrid.map((row, y) =>
      elt(
        "tr",
        {
          style: `height: ${scale}px`
        },
        ...row.map((item, x) =>
          elt("td", {
            class: `${item.symbol}`,
            id: `${zeroPad(y, 3)}y${zeroPad(x, 3)}x`
          })
        )
      )
    )
  );
}

// Deprecated
function stringToGrid(string) {
  let grid = [];
  let rowNum = 0;

  grid.push([]);

  for (let i = 0; i < string.length; i++) {
    let c = string[i];
    if (c == "\n") {
      rowNum++;
      grid.push([]);
      continue;
    }
    grid[rowNum].push(c);
  }

  return grid;
}

function WorldView(worldGrid, parent) {

  this.worldGrid = [];
  for (let inner of worldGrid) {
    this.worldGrid.push(inner.slice(0));
  }
  
  this.dom = elt("div", { class: "life" }, drawLifeGrid(this.worldGrid));
  this.initialized = false;
  this.parent = parent;

}



WorldView.prototype.clear = function() {
  this.dom.remove();
};

WorldView.prototype.initialize = function() {
  this.clear();
  this.dom.className = `${status}`;
  this.parent.appendChild(this.dom);
  this.initialized = true;
};

WorldView.prototype.render = function(newWorldGrid) {
  // // Create and append DOM objects to the body
  // var gridElement = document.createElement("div");
  // gridElement.innerHTML = "Hello";
  // document.body.appendChild(gridElement);

  for (let y = 0; y < newWorldGrid.length; y++) {
    for (let x = 0; x < newWorldGrid[0].length; x++) {
      if (newWorldGrid[y][x].symbol != this.worldGrid[y][x].symbol || 
        newWorldGrid[y][x].health && newWorldGrid[y][x].health != this.worldGrid[y][x].health) {
        this.updateGrid(y, x, newWorldGrid[y][x]);
        this.worldGrid[y][x] = newWorldGrid[y][x];
      }
    }
  }
};

WorldView.prototype.updateGrid = function(y, x, newItem) {
  let thisElement = document.getElementById(
    `${zeroPad(y, 3)}y${zeroPad(x, 3)}x`
  );

  thisElement.className = `${newItem.symbol}`;
  
  if (newItem.health > 75) {
    thisElement.classList.add("vibrant");
  } else if (newItem.health < 25) {
    thisElement.classList.add("sickly");
  } 
  
  // Add "fas" or other classes here if desired....
  // thisElement.className = `${newValue}`;
};



export { WorldView };
