/* Norton's VirtualLife rendition (2019) */
 
import { World, worldPlanBuilder } from './app/worldES6.js'
import { WorldItemFactory } from './app/worldItemFactory.js'
import { WorldAnimator } from './app/worldAnimator.js'

var app = { };

app.load = function () {

    const ROWS = 30;
    const COLS = 60;
    let itemOptions = {

        wall: { type: "wall", symbol: "w", buildChance: .1 },

        plant: { type: "plant", symbol: "p", buildChance: 0.02, 
                    ableToMoveOn: [ "empty" ], ableToEat: [],
                    healthToReproduce: 57, healthToMove: 60 },

        animal: { type: "animal", symbol: "a", buildChance: 0.02, 
                    ableToMoveOn: [ "empty" ], ableToEat: [ "plant" ],
                    plantChance: 0.07, healthToReproduce: 62, healthToMove: 62 },

        carnivore: { type: "carnivore", symbol: "c", buildChance: 0.02, 
                    ableToMoveOn: [ "empty" ], ableToEat: [ "animal" ],
                    plantChance: 0.07, vegetarianChance: 0.48, healthToReproduce: 62, healthToMove: 62 },

        empty: { type: "empty", symbol: "z", buildChance: null }
    };
    
    
    let worldPlan = worldPlanBuilder(ROWS, COLS, itemOptions);
    let worldItemFactory = new WorldItemFactory(itemOptions);
    var world = new World(worldPlan, worldItemFactory);

    var worldAnimator = new WorldAnimator(world);
    worldAnimator.start();

}

export { app };
