/* Norton's VirtualLife rendition (2019) */
class StatsView {

    constructor(worldAnimator) {

        this.worldAnimator = worldAnimator;
        this.dom = document.createElement("div");
        this.totalItems = document.createElement("div");
        this.renderTime = document.createElement("div");  
        this.turnTime = document.createElement("div");
        this.generations = document.createElement("div");
        this.dom.appendChild(this.metrics());
        this.gens = 0;
    }

}

StatsView.prototype.metrics = function() {


    let metrics = document.createElement("div");
    metrics.className = "metricsGrid";

    let startStopButton = document.createElement("button");
    startStopButton.innerText = "Start/Stop";
    startStopButton.addEventListener('click', this.worldAnimator.toggleAnimation.bind(this.worldAnimator));
    startStopButton.className = 'metricsItem';

    let animationDelay = document.createElement("div");
    animationDelay.innerText = "Delay: " + this.worldAnimator.animationDelay + "ms";
    animationDelay.className = 'metricsItem';
    
    metrics.appendChild(startStopButton);
    metrics.appendChild(animationDelay);
    metrics.appendChild(this.totalItems);
    metrics.appendChild(this.renderTime);
    metrics.appendChild(this.turnTime);
    metrics.appendChild(this.generations);

    return metrics;

}

StatsView.prototype.render = function(newWorldGrid, worldRenderTime, worldTurnTime) {

    this.gens++;
    let itemCount = 0;
    for (let row of newWorldGrid) {
        for (let item of row) {
            if (item.type !== 'empty' && item.type !== 'wall') {
                itemCount++;
            }
        }
    }

    this.totalItems.innerText = "Living: " + itemCount;
    this.renderTime.innerText = "Render: " + worldRenderTime + "ms";
    this.turnTime.innerText = "Turn: " + worldTurnTime + "ms";
    this.generations.innerText = "Gens: " + String(this.gens);

}

export { StatsView };
