/* Norton's VirtualLife rendition (2019) */
import { WorldView } from './views/worldView.js'

class WorldAnimator {

    constructor(world) {

        this.world = world;
        this.worldView = new WorldView(this.world.viewGrid(), document.body, this);
        this.worldView.initialize();
        this.animatorId = 0;
    }
}

WorldAnimator.prototype.animationDelay = 33;

WorldAnimator.prototype.toggleAnimation = function() {

    if (this.animatorId === 0) {
        this.start();
    } else {
        window.clearInterval(this.animatorId);
        this.animatorId = 0;
    }

}

WorldAnimator.prototype.start = function() {


    this.animatorId = window.setInterval(() => {

        let preTurn = new Date();
        // Turn the world
        this.world.turn();
        
        let postTurn = new Date();
        let worldTurnTime = postTurn - preTurn;

        // Render the world
        this.worldView.render(this.world.viewGrid(), worldTurnTime);

    }, this.animationDelay );

};


export { WorldAnimator }
