/* Norton's rendition of the Virtual World (May 2019) */

import { PlantWorldItem, AnimalWorldItem, CarnivoreWorldItem, WorldItem } from './worldItems.js'

function WorldItemFactory(itemOptions) { 
    
    this.itemOptions = itemOptions;

    // create symbol table for reverse lookups
    this.symbolTable = {};

    for (let type in itemOptions) {
        let symbol = this.itemOptions[type].symbol;
        this.symbolTable[symbol] = type;
    }

}

WorldItemFactory.prototype.buildFromType = function(type,latitude,longitude) {

    let typeOptions = this.itemOptions[type];
    
    switch (type) {

        case "plant":
            return new PlantWorldItem(latitude,longitude,typeOptions);

        case "animal":
            return new AnimalWorldItem(latitude,longitude,typeOptions);

        case "carnivore":
            return new CarnivoreWorldItem(latitude,longitude,typeOptions);

        default:
            return new WorldItem(latitude,longitude,typeOptions);
    }

}

WorldItemFactory.prototype.buildFromSymbol = function(symbol,latitude,longitude) {
    
    let type = this.symbolTable[symbol];
    return this.buildFromType(type,latitude,longitude);

}

export { WorldItemFactory };